$( document ).ready(function() {
    let dataTableList = null;
    let urlController = rootPath + 'admin/proyectos';
    var appConfig =  new AppConFig();
    let filters = {};
    function loadDataTable(){
         dataTableList = $('#dataTableList').DataTable({
                order: [[0, 'desc']],
                autoWidth: false,
                responsive: true,
                destroy: true,
                ajax: {
                    url: urlController + '/list/',
                },
                columns: [
                    {
                        data: 'id',
                        width: '80px'
                    },
                    {
                        data: 'nombre',
                    },
                    {
                        data: 'empresa',
                        render: function (data, type, row, meta) {
                            return row.empresa.nombre;
                        }
                    },
                    {
                        data: 'activo',
                        width: '80px',
                        class: 'text-center',
                        render: function (data, type, row, meta) {
                            let checked = '';
                            if(data)
                            {
                                checked = 'checked';
                            }
                            let html = '<label class="inline-flex items-center me-5 cursor-pointer"><input type="checkbox" class="appearance-none peer check-status" ' + checked + '><span class="switcher switcher-primary-solid"></span></label>'
                            return html;
                        }
                    },
                    {
                        data: 'id',
                        width: '80px',
                        render: function (data, type, row, meta) {
                            return appConfig.getHtmlActionsButtons(row.id);
                        }
                    },

                ],
                lengthMenu: appConfig.dataTableLengthMenu,
                pageLength: appConfig.dataTablePageLength,
                pagingType: appConfig.dataTablePagingType,
                language: appConfig.dataTableLanguageConfig,
        });
        // Búsqueda
        $('#input-search').on('keyup', function () {
            dataTableList.search(this.value).draw();
        });
        $('.filter-select').on('change', function () {
            let value = this.value;
            let filter = $(this).data('filter');
            filters[filter] = value;
            let url = urlController + '/list/';
            dataTableList.ajax.url(url + '?' + new URLSearchParams(filters).toString()).load();
        });
        $('.dataTables_filter').hide();
    }
    loadDataTable();
    appConfig.registerListeners(urlController, appConfig, dataTableList);
});
