/*! DataTables Tailwind CSS integration
 */

/*
 * This is a tech preview of Tailwind CSS integration with DataTables.
 */

// Set the defaults for DataTables initialisation
$.extend(true, DataTable.defaults, {
  dom:
    "<'grid grid-cols-12 gap-3'" +
    "<'self-center col-span-full md:col-span-6 dark:text-dark-text'l>" +
    "<'self-center col-span-full md:col-span-6 md:place-self-end'f>" +
    "<'my-2 col-span-full overflow-x-auto lg:col-span-full'tr>" +
    "<'self-center col-span-full md:col-span-6'i>" +
    "<'self-center col-span-full md:place-self-end md:col-span-6'p>" +
    ">",
  renderer: "tailwindcss",
});

// Default class modification
$.extend(DataTable.ext.classes, {
  sWrapper: "dataTables_wrapper dt-tailwindcss",
  sFilterInput: "form-input inline-block w-auto ml-2",
  sLengthSelect: "px-3 py-2 form-input form-select inline-block w-20",
  sProcessing: "dt-processing uk-panel",
  tailwindcss: {
    paging: {
      active:
        "font-semibold bg-primary-500 text-white dark:!bg-gray-700 dark:text-white",
      notActive: "bg-white",
      button:
        "size-8 border-[0.5px] border-gray-900/50 rounded-[5px] flex-center",
      enabled:
        "hover:bg-primary-500 hover:text-white dark:bg-gray-800 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white",
      notEnabled:
        "text-slate-300 border-slate-300 dark:!bg-gray-400 dark:text-slate-300",
    },
    table:
      "dataTable w-full align-middle whitespace-nowrap text-sm table-auto text-gray-500 dark:text-dark-text font-medium dark:text-gray-400",
    thead: {
      row: "",
      cell: "p-6 py-3 bg-slate-200/50 dark:bg-dark-card-two font-semibold text-left first:rounded-l-lg last:rounded-r-lg group-[.bordered]:rounded-none group-[.bordered]:border group-[.bordered]:border-gray-200 dark:group-[.bordered]:border-dark-border",
    },
    tbody: {
      row: "transition-all duration-150 ease-linear [&.selected]:bg-[#F2F4F9] dark:[&.selected]:bg-dark-icon",
      cell: "p-6 py-3 group-[.bordered]:border group-[.bordered]:border-gray-200 dark:group-[.bordered]:border-dark-border",
    },
    tfoot: {
      row: "transition-all duration-150 ease-linear",
      cell: "p-6 py-3 text-left",
    },
  },
});

// Abstract out DataTable's awful class property names were we can,
// others are handled below
DataTable.ext.classes.sTable = DataTable.ext.classes.tailwindcss.table;
DataTable.ext.classes.sStripeOdd = DataTable.ext.classes.tailwindcss.tbody.row;
DataTable.ext.classes.sStripeEven = DataTable.ext.classes.tailwindcss.tbody.row;
DataTable.ext.classes.sHeaderTH = DataTable.ext.classes.tailwindcss.thead.cell;
DataTable.ext.classes.sFooterTH = DataTable.ext.classes.tailwindcss.tfoot.cell;
DataTable.defaults.column.sClass = DataTable.ext.classes.tailwindcss.tbody.cell;

// Eventually the classes and styles to apply from above will be merged into
// DataTables core, but for now we add them in a Tailwind CSS specific file
// since this is the only one that uses them this way at the moment.
$(document).on("init.dt", function (e, settings) {
  let thead = settings.nTHead;
  let classes = DataTable.ext.classes.tailwindcss;

  $(thead).addClass(classes.thead.row);
});

/* UIkit paging button renderer */
DataTable.ext.renderer.pageButton.tailwindcss = function (
  settings,
  host,
  idx,
  buttons,
  page,
  pages
) {
  var api = new DataTable.Api(settings);
  var classes = settings.oClasses.tailwindcss.paging;
  var lang = settings.oLanguage.oPaginate;
  var aria = settings.oLanguage.oAria.paginate || {};
  var btnDisplay;

  var attach = function (container, buttons) {
    var i, ien, node, button;
    var clickHandler = function (e) {
      e.preventDefault();
      if (
        !$(e.currentTarget).hasClass("disabled") &&
        api.page() != e.data.action
      ) {
        api.page(e.data.action).draw("page");
      }
    };

    for (i = 0, ien = buttons.length; i < ien; i++) {
      button = buttons[i];

      if (Array.isArray(button)) {
        attach(container, button);
      } else {
        let enabled = false;
        let active = false;

        btnDisplay = "";

        switch (button) {
          case "ellipsis":
            btnDisplay = "&#x2026;";
            break;

          case "first":
            btnDisplay = lang.sFirst;

            if (page > 0) {
              enabled = true;
            }
            break;

          case "previous":
            btnDisplay = lang.sPrevious;

            if (page > 0) {
              enabled = true;
            }
            break;

          case "next":
            btnDisplay = lang.sNext;

            if (page < pages - 1) {
              enabled = true;
            }
            break;

          case "last":
            btnDisplay = lang.sLast;

            if (page < pages - 1) {
              enabled = true;
            }
            break;

          default:
            btnDisplay = button + 1;
            enabled = true;

            if (page === button) {
              active = true;
            }
            break;
        }

        if (btnDisplay) {
          var className =
            classes.button +
            " " +
            (active ? classes.active : classes.notActive) +
            " " +
            (enabled ? classes.enabled : classes.notEnabled);

          node = $("<a>", {
            href: enabled ? "#" : null,
            "aria-controls": settings.sTableId,
            "aria-disabled": enabled ? null : "true",
            "aria-label": aria[button],
            role: "link",
            "aria-current": active ? "page" : null,
            "data-dt-idx": button,
            tabindex: enabled ? settings.iTabIndex : -1,
            class: className,
            id:
              idx === 0 && typeof button === "string"
                ? settings.sTableId + "_" + button
                : null,
          })
            .html(btnDisplay)
            .appendTo(container);

          settings.oApi._fnBindAction(node, { action: button }, clickHandler);
        }
      }
    }
  };

  var hostEl = $(host);
  var activeEl = hostEl.find(document.activeElement).data("dt-idx");
  var paginationEl = hostEl.children("ul.pagination");

  if (paginationEl.length) {
    paginationEl.empty();
  } else {
    paginationEl = hostEl
      .html('<div class="flex-center gap-2"/>')
      .children("div");
  }

  attach(paginationEl, buttons);

  paginationEl.children(":first-child").addClass(classes.first);
  paginationEl.children(":last-child").addClass(classes.last);

  if (activeEl !== undefined) {
    hostEl.find("[data-dt-idx=" + activeEl + "]").trigger("focus");
  }
};
