# CakePHP Ajax Plugin
[![CI](https://github.com/dereuromark/cakephp-ajax/actions/workflows/ci.yml/badge.svg?branch=master)](https://github.com/dereuromark/cakephp-ajax/actions/workflows/ci.yml?query=branch%3Amaster)
[![Coverage Status](https://codecov.io/gh/dereuromark/cakephp-ajax/branch/master/graph/badge.svg)](https://codecov.io/gh/dereuromark/cakephp-ajax)
[![Latest Stable Version](https://poser.pugx.org/dereuromark/cakephp-ajax/v/stable.svg)](https://packagist.org/packages/dereuromark/cakephp-ajax)
[![Minimum PHP Version](https://img.shields.io/badge/php-%3E%3D%208.1-8892BF.svg)](https://php.net/)
[![License](https://poser.pugx.org/dereuromark/cakephp-ajax/license.svg)](LICENSE)
[![Total Downloads](https://poser.pugx.org/dereuromark/cakephp-ajax/d/total.svg)](https://packagist.org/packages/dereuromark/cakephp-ajax)
[![Coding Standards](https://img.shields.io/badge/cs-PSR--2--R-yellow.svg)](https://github.com/php-fig-rectified/fig-rectified-standards)

A CakePHP plugin that makes working with AJAX a "piece of cake".

This branch is for **CakePHP 5.0+**. For details see [version map](https://github.com/dereuromark/cakephp-ajax/wiki#cakephp-version-map).

## What is this plugin for?
Basically DRY (Don't repeat yourself) and easy AJAX handling.

### Demo
See the [Sandbox app](https://sandbox.dereuromark.de/sandbox/ajax-examples) for live demos.

### Key features
- Auto-handling via View class mapping and making controller actions available both AJAX and non-AJAX by design.
- Flash message and redirect (prevention) support.

See [my article](https://www.dereuromark.de/2014/01/09/ajax-and-cakephp/) for details on the history of this view class and plugin code.

## Installation & Docs

- [Documentation](docs/README.md)

### Possible TODOs

* Maybe add helpers and additional goodies around auto-complete, edit-in-place, ...
