<!DOCTYPE html>
<html lang="en" class="group" data-sidebar-size="lg" data-card-style="round">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title><?= __('Oportunidad de negocio | Tu aliado en compras públicas') ?></title>
    <meta name="robots" content="noindex, follow">
    <meta name="description" content="<?= __('Oportunidad de negocio | Tu aliado en compras públicas') ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Favicon -->
    <?= $this->Html->meta('icon') ?>
    <!-- Style CSS -->
    <?php echo $this->Html->css('/admin/assets/css/vendor/select/select2.min.css'); ?>
    <?php echo $this->Html->css('/admin/assets/css/vendor/snackbar/snackbar.min.css'); ?>
    <?php echo $this->Html->css('/admin/assets/css/output.css'); ?>
</head>
<body class="bg-body-light dark:bg-dark-body group-data-[theme-width=box]:container group-data-[theme-width=box]:max-w-screen-3xl xl:group-data-[theme-width=box]:px-4">
    <!-- Start Loader -->
    <?= $this->element('admin/loader') ?>
    <!-- End Loader -->
    <!-- Start Header -->
    <?= $this->element('admin/header') ?>
    <!-- End Header -->
     <!-- Start Menu -->
    <?= $this->element('admin/menu') ?>
    <!-- End Menu -->
    <div class="main-content group-data-[sidebar-size=lg]:xl:ml-[calc(theme('spacing.app-menu')_+_16px)] group-data-[sidebar-size=sm]:xl:ml-[calc(theme('spacing.app-menu-sm')_+_16px)] px-4 group-data-[theme-width=box]:xl:px-0 ac-transition">
        <?php
        $this->Breadcrumbs->setTemplates([
            'wrapper' => '<ul class="flex items-center flex-wrap gap-1.5 *:flex-center *:gap-1.5 leading-none text-gray-900 dark:text-dark-text">{{content}}</ul>',
            'item' => '<li class="text-primary-500 after:font-remix after:flex-center after:font-thin after:text-gray-900 after:size-5 after:content-[\'\\ea6e\'] after:translate-y-[1.4px] last:after:hidden"><a href="{{url}}">{{title}}</a></li>',
            'itemWithoutLink' => '<li class=current-page after:font-remix after:flex-center after:font-thin after:text-gray-900 after:size-5 after:content-[\'\\ea6e\'] after:translate-y-[1.4px] last:after:hidden">{{title}}</li>',
        ]);
        ?>
        <div class="card">
            <?php echo $this->Breadcrumbs->render(); ?>
        </div>
        <?= $this->fetch('content') ?>
        <div id="editModal" tabindex="-1" class="hidden fixed inset-0 z-modal flex-center w-full md:inset-0 h-[calc(100%-1rem)]  overflow-x-hidden overflow-y-auto">
            <div class="p-4 w-full max-w-3xl max-h-screen">
                <div class="relative bg-white dark:bg-dark-tooltip rounded-lg shadow dk-theme-card-square">
                    <button type="button" data-modal-hide="editModal" class="absolute top-3 end-2.5 text-gray-500 dark:text-dark-text hover:bg-gray-200 dark:hover:bg-dark-icon rounded-lg size-8 flex-center dk-theme-card-square">
                        <i class="ri-close-line text-inherit text-xl leading-none"></i>
                    </button>
                    <div id="contentModal" class="p-4 md:p-5">

                    </div>
                </div>
            </div>
        </div>
    </div>
    <?= $this->Html->script('/admin/assets/js/vendor/jquery.min.js'); ?>
    <?= $this->Html->script('/admin/assets/js/vendor/select/select2.min.js'); ?>
    <?= $this->Html->script('/admin/assets/js/vendor/snackbar/snackbar.min.js'); ?>
    <?= $this->Html->script('/admin/assets/js/vendor/smooth-scrollbar/smooth-scrollbar.min.js'); ?>
     <!-- datatable -->
    <?= $this->Html->script('/admin/assets/js/vendor/datatables/data-tables.min.js'); ?>
    <?= $this->Html->script('/admin/assets/js/vendor/datatables/data-tables.tailwindcss.min.js'); ?>
    <?= $this->Html->script('/admin/assets/js/vendor/datatables/datatables.buttons.min.js'); ?>
     <!-- sweetalert -->
    <?= $this->Html->script('/admin/assets/js/vendor/sweetalert2/sweetalert2.min.js'); ?>

    <?= $this->Html->script('/admin/assets/js/vendor/flowbite.min.js'); ?>
    <?= $this->Html->script('/admin/assets/js/component/app-menu-bar.js'); ?>
    <?= $this->Html->script('/admin/assets/js/switcher.js'); ?>
    <?= $this->Html->script('/admin/assets/js/layout.js'); ?>
    <?= $this->Html->script('/admin/assets/js/main.js'); ?>
    <?= $this->Html->script('/admin/assets/js/app-config.js'); ?>
    <?= $this->Html->script('/admin/assets/js/component/button-loading.js'); ?>
    <script>
    var rootPath = '<?php echo $this->Url->build('/'); ?>';
    var wwwPath = '<?php echo WWW_ROOT; ?>';
    var root = '<?php echo ROOT; ?>';
    var _csrfToken = "<?= $this->request->getCookie('csrfToken') ?>";
    </script>
    <?php
    $js = '/admin/custom/js/'.strtolower($controllerName).'/'.strtolower($actionName).'.js?v='.$versionAdmin;
    $jsPath = WWW_ROOT.'admin/custom/js/'.strtolower($controllerName).'/'.strtolower($actionName).'.js';
    $info = new SplFileInfo($jsPath);
    if($info->isFile())
    {
        echo $this->Html->script($js);
    }
    ?>
</body>
</html>
