<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ConfigurationCompany $configurationCompany
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Configuration Company'), ['action' => 'edit', $configurationCompany->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Configuration Company'), ['action' => 'delete', $configurationCompany->id], ['confirm' => __('Are you sure you want to delete # {0}?', $configurationCompany->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Configuration Companies'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Configuration Company'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="configurationCompanies view content">
            <h3><?= h($configurationCompany->title) ?></h3>
            <table>
                <tr>
                    <th><?= __('Title') ?></th>
                    <td><?= h($configurationCompany->title) ?></td>
                </tr>
                <tr>
                    <th><?= __('Company') ?></th>
                    <td><?= $configurationCompany->hasValue('company') ? $this->Html->link($configurationCompany->company->name, ['controller' => 'Companies', 'action' => 'view', $configurationCompany->company->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Created Ip') ?></th>
                    <td><?= h($configurationCompany->created_ip) ?></td>
                </tr>
                <tr>
                    <th><?= __('Modified Ip') ?></th>
                    <td><?= h($configurationCompany->modified_ip) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($configurationCompany->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Status') ?></th>
                    <td><?= $this->Number->format($configurationCompany->status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Created Id') ?></th>
                    <td><?= $this->Number->format($configurationCompany->created_id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Modified Id') ?></th>
                    <td><?= $this->Number->format($configurationCompany->modified_id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Created Date') ?></th>
                    <td><?= h($configurationCompany->created_date) ?></td>
                </tr>
                <tr>
                    <th><?= __('Modified Date') ?></th>
                    <td><?= h($configurationCompany->modified_date) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Key Words') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($configurationCompany->key_words)); ?>
                </blockquote>
            </div>
        </div>
    </div>
</div>