<?php
namespace App\Text;
class Messages
{
    public static function messages(): array
    {
        return [
            'REQUIRED' => __('Este campo es requerido.'),
            'INVALID_EMAIL' => __('Debe ingresar un correo válido.'),
            'MUST_BE_INTEGER' => __('El campo debe ser numérico.'),
            'PASSWORD_LENGTH' => __('La contraseña debe tener entre 4 y 20 carácteres.'),
            'USERNAME_EXISTS' => __('El nombre de usuario ingresado ya existe.'),
            'EMAIL_EXISTS' => __('El correo ingresado ya existe.'),
            'INVALID_RUT' => __('El rut ingresado no es válido.'),
            'RUT_EXISTS' => __('El rut ingresado ya existe.'),
        ];
    }
    public static function success(string $action, string $article, string $model, string $gender = 'o'): string
    {
        $template = match ($action) {
            'add'    => '{article} {model} ha sido guardad{gender} correctamente.',
            'edit'   => '{article} {model} ha sido editad{gender} correctamente.',
            'delete' => '{article} {model} ha sido eliminad{gender} correctamente.',
            default  => '{article} {model} ha sido procesad{gender} correctamente.'
        };

        return __($template, [
            'article' => $article,
            'model' => $model,
            'gender' => $gender
        ]);
    }

    public static function error(string $action, string $article, string $model): string
    {
        $template = match ($action) {
            'add'    => 'No se pudo guardar {article} {model}. Inténtalo nuevamente.',
            'edit'   => 'No se pudo editar {article} {model}. Inténtalo nuevamente.',
            'delete' => 'No se pudo eliminar {article} {model}. Inténtalo nuevamente.',
            default  => 'No se pudo procesar {article} {model}. Inténtalo nuevamente.'
        };

        return __($template, [
            'article' => $article,
            'model' => $model
        ]);
    }

    public static function get(string $key): string
    {
        return static::messages()[$key] ?? '';
    }
}
