<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ProyectosPalabrasClaves Model
 *
 * @property \App\Model\Table\ProyectosTable&\Cake\ORM\Association\BelongsTo $Proyectos
 * @property \App\Model\Table\PalabrasClavesTable&\Cake\ORM\Association\BelongsTo $PalabraClaves
 *
 * @method \App\Model\Entity\ProyectosPalabrasClave newEmptyEntity()
 * @method \App\Model\Entity\ProyectosPalabrasClave newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\ProyectosPalabrasClave> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\ProyectosPalabrasClave get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\ProyectosPalabrasClave findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\ProyectosPalabrasClave patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\ProyectosPalabrasClave> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\ProyectosPalabrasClave|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\ProyectosPalabrasClave saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\ProyectosPalabrasClave>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProyectosPalabrasClave>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProyectosPalabrasClave>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProyectosPalabrasClave> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProyectosPalabrasClave>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProyectosPalabrasClave>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProyectosPalabrasClave>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProyectosPalabrasClave> deleteManyOrFail(iterable $entities, array $options = [])
 */
class ProyectosPalabrasClavesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('proyectos_palabras_claves');
        $this->setDisplayField('created_ip');
        $this->setPrimaryKey('id');
        $this->addBehavior('Register');

        $this->belongsTo('Proyectos', [
            'foreignKey' => 'proyecto_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('PalabraClaves', [
            'foreignKey' => 'palabra_clave_id',
            'className' => 'PalabrasClaves',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('proyecto_id')
            ->notEmptyString('proyecto_id');

        $validator
            ->integer('palabra_clave_id')
            ->notEmptyString('palabra_clave_id');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['proyecto_id'], 'Proyectos'), ['errorField' => 'proyecto_id']);
        $rules->add($rules->existsIn(['palabra_clave_id'], 'PalabraClaves'), ['errorField' => 'palabra_clave_id']);

        return $rules;
    }
}
