<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PalabrasClavesLicitaciones Model
 *
 * @property \App\Model\Table\PalabrasClavesTable&\Cake\ORM\Association\BelongsTo $PalabraClaves
 * @property \App\Model\Table\ProyectosTable&\Cake\ORM\Association\BelongsToMany $Proyectos
 *
 * @method \App\Model\Entity\PalabrasClavesLicitacione newEmptyEntity()
 * @method \App\Model\Entity\PalabrasClavesLicitacione newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\PalabrasClavesLicitacione> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\PalabrasClavesLicitacione get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\PalabrasClavesLicitacione findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\PalabrasClavesLicitacione patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\PalabrasClavesLicitacione> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\PalabrasClavesLicitacione|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\PalabrasClavesLicitacione saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\PalabrasClavesLicitacione>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\PalabrasClavesLicitacione>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\PalabrasClavesLicitacione>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\PalabrasClavesLicitacione> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\PalabrasClavesLicitacione>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\PalabrasClavesLicitacione>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\PalabrasClavesLicitacione>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\PalabrasClavesLicitacione> deleteManyOrFail(iterable $entities, array $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class PalabrasClavesLicitacionesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('palabras_claves_licitaciones');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('PalabraClaves', [
            'foreignKey' => 'palabra_clave_id',
            'className' => 'PalabrasClaves',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Licitaciones', [
            'foreignKey' => 'licitacion_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsToMany('Proyectos', [
            'foreignKey' => 'palabras_claves_licitacion_id',
            'targetForeignKey' => 'proyecto_id',
            'joinTable' => 'proyectos_palabras_claves_licitaciones',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('palabra_clave_id')
            ->notEmptyString('palabra_clave_id');

        $validator
            ->integer('licitacion_id')
            ->requirePresence('licitacion_id', 'create')
            ->notEmptyString('licitacion_id');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['palabra_clave_id'], 'PalabraClaves'), ['errorField' => 'palabra_clave_id']);

        return $rules;
    }
}
