<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Empresas Model
 *
 * @property \App\Model\Table\ProyectosTable&\Cake\ORM\Association\HasMany $Proyectos
 * @property \App\Model\Table\UsuariosTable&\Cake\ORM\Association\HasMany $Usuarios
 *
 * @method \App\Model\Entity\Empresa newEmptyEntity()
 * @method \App\Model\Entity\Empresa newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Empresa> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Empresa get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Empresa findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Empresa patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Empresa> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Empresa|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Empresa saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Empresa>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Empresa>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Empresa>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Empresa> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Empresa>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Empresa>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Empresa>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Empresa> deleteManyOrFail(iterable $entities, array $options = [])
 */
class EmpresasTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('empresas');
        $this->setDisplayField('nombre');
        $this->setPrimaryKey('id');

        $this->hasMany('Proyectos', [
            'foreignKey' => 'empresa_id',
        ]);
        $this->hasMany('Usuarios', [
            'foreignKey' => 'empresa_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('nombre')
            ->maxLength('nombre', 250)
            ->requirePresence('nombre', 'create')
            ->notEmptyString('nombre');

        $validator
            ->integer('created_id')
            ->requirePresence('created_id', 'create')
            ->notEmptyString('created_id');

        $validator
            ->dateTime('created_date')
            ->requirePresence('created_date', 'create')
            ->notEmptyDateTime('created_date');

        $validator
            ->scalar('created_ip')
            ->maxLength('created_ip', 40)
            ->requirePresence('created_ip', 'create')
            ->notEmptyString('created_ip');

        $validator
            ->integer('modified_id')
            ->requirePresence('modified_id', 'create')
            ->notEmptyString('modified_id');

        $validator
            ->dateTime('modified_date')
            ->requirePresence('modified_date', 'create')
            ->notEmptyDateTime('modified_date');

        $validator
            ->scalar('modified_ip')
            ->maxLength('modified_ip', 40)
            ->requirePresence('modified_ip', 'create')
            ->notEmptyString('modified_ip');

        return $validator;
    }
}
