<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;
use Authentication\PasswordHasher\DefaultPasswordHasher;

/**
 * Usuario Entity
 *
 * @property int $id
 * @property string $nombre
 * @property string $apellido
 * @property string|null $email
 * @property string $clave
 * @property int $rol_id
 * @property int $empresa_id
 * @property bool $activo
 * @property bool $cambiar_clave
 * @property string|null $token_cambio_clave
 * @property \Cake\I18n\DateTime|null $fecha_token_cambio_clave
 * @property int $created_id
 * @property \Cake\I18n\DateTime $created_date
 * @property string $created_ip
 * @property int $modified_id
 * @property \Cake\I18n\DateTime $modified_date
 * @property string $modified_ip
 *
 * @property \App\Model\Entity\Rol $rol
 * @property \App\Model\Entity\Empresa $empresa
 */
class Usuario extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'nombre' => true,
        'apellido' => true,
        'email' => true,
        'clave' => true,
        'rol_id' => true,
        'empresa_id' => true,
        'activo' => true,
        'cambiar_clave' => true,
        'token_cambio_clave' => true,
        'fecha_token_cambio_clave' => true,
        'created_id' => true,
        'created_date' => true,
        'created_ip' => true,
        'modified_id' => true,
        'modified_date' => true,
        'modified_ip' => true,
        'rol' => true,
        'empresa' => true,
    ];
    /**
     * Fields that are excluded from JSON versions of the entity.
     *
     * @var array<string>
     */
    protected array $_hidden = [
        'clave',
    ];
    protected array $_virtual = ['full_name'];
    protected function _setClave(string $password) : ?string
    {
        if (strlen($password) > 0) {
            return (new DefaultPasswordHasher())->hash($password);
        }
        return '';
    }
    public function getFullName(){
        return $this->nombre.' '.$this->apellido;
    }
     protected function _getFullName(): string
    {
        return $this->nombre . ' ' . $this->apellido;
    }
}
