<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Licitacione Entity
 *
 * @property int $id
 * @property int $modalidad_licitacion_id
 * @property int $agil_id
 * @property string|null $codigo_externo
 * @property string|null $nombre
 * @property bool|null $estado_id
 * @property \Cake\I18n\DateTime|null $fecha_cierre
 * @property string|null $fecha_proceso
 * @property \Cake\I18n\DateTime $fecha_creacion
 * @property int|null $estado
 *
 * @property \App\Model\Entity\PalabrasClave[] $palabras_claves
 * @property \App\Model\Entity\ProyectosPalabrasClave[] $proyectos_palabras_claves
 */
class Licitacione extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'modalidad_licitacion_id' => true,
        'agil_id' => true,
        'codigo_externo' => true,
        'nombre' => true,
        'estado_id' => true,
        'fecha_cierre' => true,
        'fecha_proceso' => true,
        'fecha_creacion' => true,
        'estado' => true,
        'palabras_claves' => true,
        'proyectos_palabras_claves' => true,
    ];
}
